/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#if !defined(AFX_REALIPRESOLVER_H__8C75766D_2A7E_4212_A927_1888CB056CD1__INCLUDED_)
#define AFX_REALIPRESOLVER_H__8C75766D_2A7E_4212_A927_1888CB056CD1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ErrorHandler.h"

#include "Socket.h"

#include <vector>

KOMODIA_NAMESPACE_START

//Important - when using this class you must link with iphlpapi.lib
class CRealIPResolver : public CErrorHandler
{
public:
	//Resolve the IP (will block until resolved)
	//Will try to test the address by connecting to rTestURL:usPort
	//To disable test send a blank rTestURL however if NIC contains multiple addresses
	//The resolve will not be able to determine which address is the correct one and will
	//Return nothing.
	IP Resolve(IP aInternetIP=83974850,
			   const std::string& rTestURL="www.google.com",
			   unsigned short usPort=80);

	//Check if address is a NAT address
	BOOL IsNATAddress(IP aIP)const;

	//Ctor and Dtor
	CRealIPResolver();
	virtual ~CRealIPResolver();
private:
	//Our vector of IPs
	typedef std::vector<IP> IPVector;
private:
	//No copy Ctor
	CRealIPResolver(const CRealIPResolver& rResolver);

	//No copy operator
	CRealIPResolver& operator=(const CRealIPResolver& rResolver);

	//Convert an adapter symbolic name
	std::string ConvertSymbolic(const char* pName)const;

	//Extract the IP from the data
	IPVector ExtractIP(const void* pData)const;

	//Test an address
	BOOL TestAddress(IP aAddress,
					 IP aTestAddress,
					 unsigned short usPort)const;
};

KOMODIA_NAMESPACE_END

#endif // !defined(AFX_REALIPRESOLVER_H__8C75766D_2A7E_4212_A927_1888CB056CD1__INCLUDED_)
