/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#if !defined(AFX_RELAY_H__392559E8_57ED_4880_9037_FB2F34253C72__INCLUDED_)
#define AFX_RELAY_H__392559E8_57ED_4880_9037_FB2F34253C72__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ErrorHandler.h"

#include "Socket.h"

KOMODIA_NAMESPACE_START

class CRelay : public CErrorHandler
{
public:
	//Set/get disconnection timeout
	//Default is 0, which means no timeout (in MS)
	void SetTimeout(unsigned long ulTimeoutMS);
	unsigned long GetTimeout()const;

	//Start the relay
	virtual BOOL Relay(const std::string& rBindAddress,
					   unsigned short usBindPort,
					   const std::string& rDestinationAddress,
					   unsigned short usDestinationPort)=0;
	virtual BOOL Relay(IP aBindAddress,
					   unsigned short usBindPort,
					   IP aDestinationAddress,
					   unsigned short usDestinationPort)=0;

	//Stop the relay
	virtual BOOL Stop()=0;

	//Ctor and Dtor
	CRelay();
	virtual ~CRelay();
private:
	//No copy Ctor
	CRelay(const CRelay& rRelay);

	//No copy operator
	CRelay& operator=(const CRelay& rRelay);

	//Our timeout
	unsigned long m_ulTimeout;
};

KOMODIA_NAMESPACE_END

#endif // !defined(AFX_RELAY_H__392559E8_57ED_4880_9037_FB2F34253C72__INCLUDED_)
