/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#if !defined(AFX_TCPRELAY_H__C59C4BC6_68A9_427C_A399_A233B48C459E__INCLUDED_)
#define AFX_TCPRELAY_H__C59C4BC6_68A9_427C_A399_A233B48C459E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Relay.h"

#include "TCPSocketAsync.h"

#include <map>

KOMODIA_NAMESPACE_START

class CGenericCriticalSection;

class CTCPRelay : public CRelay
{
public:
	//Our connection ID
	typedef unsigned short ConnectionID;
public:
	//Are we running
	BOOL IsRunning()const;

	//Start the relay
	virtual BOOL Relay(const std::string& rBindAddress,
					   unsigned short usBindPort,
					   const std::string& rDestinationAddress,
					   unsigned short usDestinationPort);
	virtual BOOL Relay(IP aBindAddress,
					   unsigned short usBindPort,
					   IP aDestinationAddress,
					   unsigned short usDestinationPort);

	//Stop the relay
	virtual BOOL Stop();

	//Ctor and Dtor
	CTCPRelay();
	virtual ~CTCPRelay();
protected:
	//Modify the received string
	virtual std::string ModifyReceiveString(BOOL bIncoming,
											const char* pBuffer,
											unsigned short usBufferSize)const;

	//Get the bind address
	IP GetBindAddress()const;

	//Get target
	IP GetTarget()const;
private:
	//Our accept socket
	class CAcceptSocket : public CTCPSocketAsync
	{
	public:
		//Ctor and Dtor
		CAcceptSocket(CTCPRelay* pFather);
		virtual ~CAcceptSocket();
	protected:
		//When a socket can accept an incoming connection
		virtual BOOL OnSocketAccept(int iErrorCode);

		//No events
		NO_OnSocketOOB
		NO_OnSocketWrite
		NO_OnSocketTimeout
		NO_OnSocketConnect
		NO_OnSocketClose
		NO_OnSocketReceive
	private:
		//Our father
		CTCPRelay* m_pFather;
	};

	friend CAcceptSocket;
private:
	//Our client socket
	class CClientSocket : public CTCPSocketAsync
	{
	public:
		//Send data over the sockets
		virtual int Send(const char* pBuffer,
						 unsigned long ulBufferLength);

		//Stop the sockets
		void Stop();

		//Set the connection ID
		void SetConnectionID(ConnectionID aConnectionID);

		//Try to connect
		void Connect();

		//Set the other side
		void SetSocket(CClientSocket* pSocket);

		//Ctor and Dtor
		CClientSocket(CTCPRelay* pFather,
					  CClientSocket* pSocket);
		virtual ~CClientSocket();
	protected:
		//When a socket got a connect event (after calling connect)
		virtual BOOL OnSocketConnect(int iErrorCode);

		//When a socket was closed
		virtual BOOL OnSocketClose(int iErrorCode);

		//When socket has data in queue
		virtual BOOL OnSocketReceive(int iErrorCode);

		//When a timeout occured (implemented at library level)
		//User should return 0, if proccessed the message
		virtual BOOL OnSocketTimeout();

		//No events
		NO_OnSocketAccept
		NO_OnSocketOOB
		NO_OnSocketWrite
	private:
		//Our father
		CTCPRelay* m_pFather;

		//Our other side
		CClientSocket* m_pSocket;

		//Our connection ID
		ConnectionID m_aConnectionID;

		//Are we the incoming
		BOOL m_bIncoming;

		//Our CS
		CGenericCriticalSection* m_pCSection;

		//Do we have an event
		BOOL m_bEvent;
	};

	friend CClientSocket;
private:
	//Our struct of two sockets
	typedef struct _SocketData
	{
		CClientSocket*	pIncomingConnection;
		CClientSocket*	pOutgoingConnection;
	} SocketData;

	//Our map of sockets (according to connection IDs)
	typedef std::map<ConnectionID,SocketData> ClientMap;
private:
	//No copy Ctor
	CTCPRelay(const CTCPRelay& rRelay);

	//No copy operator
	CTCPRelay& operator=(const CTCPRelay& rRelay);

	//Add a connection
	ConnectionID NewConnection(CClientSocket* pIncomingConnection,
							   CClientSocket* pOutgoingConnection);

	//Remove a connection
	void RemoveConnection(ConnectionID aConnectionID);

	//Get target port
	unsigned short GetTargetPort()const;

	//Our accept socket
	CAcceptSocket* m_pSocket;

	//Our client map
	ClientMap m_aClientMap;

	//Our CS
	CGenericCriticalSection* m_pCSection;

	//Our bind address
	IP m_aBindAddress;

	//Our destination address
	IP m_aTarget;

	//Our target port
	unsigned short m_usTargetPort;

	//Running ID
	ConnectionID m_aRunningID;

	//Are we created?
	BOOL m_bCreated;
};

KOMODIA_NAMESPACE_END

#endif // !defined(AFX_TCPRELAY_H__C59C4BC6_68A9_427C_A399_A233B48C459E__INCLUDED_)
