/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#if !defined(AFX_TCPRELAYHTTP_H__9B94F084_92A1_432B_8361_943C2B5E5216__INCLUDED_)
#define AFX_TCPRELAYHTTP_H__9B94F084_92A1_432B_8361_943C2B5E5216__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TCPRelay.h"

KOMODIA_NAMESPACE_START

class CTCPRelayHTTP : public CTCPRelay  
{
public:
	//Start the relay
	virtual BOOL Relay(const std::string& rBindAddress,
					   unsigned short usBindPort,
					   const std::string& rDestinationAddress,
					   unsigned short usDestinationPort);
	virtual BOOL Relay(IP aBindAddress,
					   unsigned short usBindPort,
					   IP aDestinationAddress,
					   unsigned short usDestinationPort);

	//Ctor and Dtor
	CTCPRelayHTTP();
	virtual ~CTCPRelayHTTP();
protected:
	virtual std::string ModifyReceiveString(BOOL bIncoming,
											const char* pBuffer,
											unsigned short usBufferSize)const;
private:
	//No copy Ctor
	CTCPRelayHTTP(const CTCPRelayHTTP& rRelay);

	//No copy operator
	CTCPRelayHTTP& operator=(const CTCPRelayHTTP& rRelay);

	//Replace the string
	BOOL ReplaceString(std::string& rString)const;

	//Our target string
	std::string m_sTargetAddress;

	//Our bind string
	std::string m_sBindAddress;
};

KOMODIA_NAMESPACE_END

#endif // !defined(AFX_TCPRELAYHTTP_H__9B94F084_92A1_432B_8361_943C2B5E5216__INCLUDED_)
