/*
 *  Copyright (c) 2000-2003 Barak Weichselbaum <barak@komodia.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contact info:
 * -------------
 *
 * Site:					http://www.komodia.com
 * Main contact:			barak@komodia.com
 * For custom projects, 
 * consulting, or other
 * paid services:			sales@komodia.com
 */

#if !defined(AFX_WHOISSOCKET_H__6D6F3BD7_F9C3_4994_B9B2_58A75CD8208C__INCLUDED_)
#define AFX_WHOISSOCKET_H__6D6F3BD7_F9C3_4994_B9B2_58A75CD8208C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning(disable:4786)

#include "TCPSocketAsync.h"

#include <map>
#include <vector>

KOMODIA_NAMESPACE_START

class CWhoisSocket : public CTCPSocketAsync
{
public:
	//Our servers
	typedef enum _WhoisServer
	{
		wsNone,
		wsArin,
		wsApnic,
		wsRipe,
		wsLast
	} WhoisServer;

	//Vector a breaked address
	typedef std::vector<std::string> AddressVector;
public:
	//Get the target server
	const std::string& GetLastTarget()const;

	//Get the additional whois server
	const std::string& GetAdditionalWhoisServer()const;

	//Get an address for whois
	static std::string GetAddressForWhois(const std::string& rAddress);

	//Break an address
	static AddressVector AnalyzeAddress(const std::string& rAddress);

	//Get type of trace
	BOOL IsIPTrace()const;

	//Set the timeout
	void SetWhoisTimeout(DWORD dwMS);

	//Get the whois data
	const std::string& GetWhoisData()const;

	//Did we have an error
	virtual BOOL IsError()const;

	//Are we done
	virtual BOOL IsWhoisDone()const;

	//Create this socket as a regular socket
	virtual BOOL Create();

	//Trace a URL
	BOOL WhoisURL(const std::string& rURL);
	BOOL WhoisURL(const std::string& rURL,
				  const std::string& rWhoisServer);

	//Trace an IP
	BOOL WhoisIP(const std::string& rIP);
	BOOL WhoisIP(IP aAddress);
	BOOL WhoisIP(IP aAddress,
				 const std::string& rWhoisServer);

	//Ctor and Dtor
	CWhoisSocket(BOOL bAsync);
	virtual ~CWhoisSocket();
protected:
	//Overide when the query is done
	virtual void WhoisDone(BOOL bError);

	//Socket events
	virtual BOOL OnSocketTimeout();
	virtual BOOL OnSocketConnect(int iErrorCode);
	virtual BOOL OnSocketClose(int iErrorCode);
	virtual BOOL OnSocketReceive(int iErrorCode);
	NO_OnSocketAccept
 	NO_OnSocketOOB
	NO_OnSocketWrite

	//Get the whois server
	const std::string& GetWhoisServer(const std::string& rURL)const;
private:
	//Our whois MAP
	typedef std::map<std::string,std::string> WhoisMAP;
private:
	//ctor for map build
	CWhoisSocket();

	//Extract the addtional DNS server
	std::string ExtractAdditionalWhoisServer(const std::string rWhoisQuery)const;

	//Populate the map
	static void PopulateMap();

	//Set the query is done
	void QueryDone(BOOL bError,
				   BOOL bReallocate);

	//Process a string and modify it's 10
	void ModifyString(std::string& rString)const;

	//Modify the buffer
	void ModifyBuffer(char* pBuffer,
					  int iBufferSize)const;

	//Send the URL
	BOOL SendURL(const std::string& rURL);

	//Receive data from the whois
	BOOL ReceiveWhois();

	//The whois data
	char* m_pData;
	
	//Data size
	unsigned long m_ulDataSize;

	//Our extensions
	static std::string m_sData[];

	//Empty string
	static std::string m_sEmpty;

	//Our IP whois
	static std::string m_aIPWhois[wsLast];

	//Whois not found strings
	static std::string m_aWhoisNotFound[wsLast];

	//Are we async
	BOOL m_bAsync;

	//Are we whoising ?
	BOOL m_bDone;

	//Did we have an error
	BOOL m_bError;

	//The whois data
	std::string m_sWhoisData;

	//Server we searched
	WhoisServer m_aServer;

	//Where are we
	WhoisServer m_aProgress;

	//Data to send
	std::string m_sDataToSend;

	//Our timeout
	DWORD m_dwTimeout;

	//What trace are we doing
	BOOL m_bURL;

	//Our data map
	static WhoisMAP m_aData;

	//Our building instance
	static CWhoisSocket m_aSocket;

	//Our whois clause
	static const std::string m_sWhoisClause;

	//Do we have another whois server
	std::string m_sAdditionalWhoisServer;

	//Does our whois server has additional whois servers
	BOOL m_bAdditionalServer;
};

KOMODIA_NAMESPACE_END

#endif // !defined(AFX_WHOISSOCKET_H__6D6F3BD7_F9C3_4994_B9B2_58A75CD8208C__INCLUDED_)
